/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.entities.factories.FurnitureEntityAttributesFactory;
import technology.rocketjump.undermount.entities.factories.FurnitureEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.designation.TileDesignationDictionary;
import technology.rocketjump.undermount.messaging.types.AreaSelectionMessage;
import technology.rocketjump.undermount.messaging.types.DebugMessage;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.FurniturePlacementMessage;
import technology.rocketjump.undermount.messaging.types.MouseChangeMessage;
import technology.rocketjump.undermount.messaging.types.RoomPlacementMessage;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.GameInteractionStateContainer;
import technology.rocketjump.undermount.ui.views.GuiViewName;

@Singleton
public class GameInteractionProcessor
implements Telegraph,
Disposable,
GameContextAware {
    private static final float ENTITY_SELECTION_RADIUS2 = 0.25f;
    private final MessageDispatcher messageDispatcher;
    private final GameInteractionStateContainer interactionStateContainer;
    private final FurnitureEntityAttributesFactory furnitureEntityAttributesFactory;
    private final FurnitureEntityFactory furnitureEntityFactory;
    private final DebugWindow debugWindow;
    private GameContext gameContext;

    @Inject
    public GameInteractionProcessor(MessageDispatcher messageDispatcher, GameInteractionStateContainer interactionStateContainer, TileDesignationDictionary tileDesignationDictionary, FurnitureEntityAttributesFactory furnitureEntityAttributesFactory, FurnitureEntityFactory furnitureEntityFactory, DebugWindow debugWindow) {
        this.messageDispatcher = messageDispatcher;
        this.interactionStateContainer = interactionStateContainer;
        this.furnitureEntityAttributesFactory = furnitureEntityAttributesFactory;
        this.furnitureEntityFactory = furnitureEntityFactory;
        this.debugWindow = debugWindow;
        messageDispatcher.addListener(this, 200);
        messageDispatcher.addListener(this, 201);
        messageDispatcher.addListener(this, 202);
        messageDispatcher.addListener(this, 203);
        messageDispatcher.addListener(this, 802);
        messageDispatcher.addListener(this, 257);
        messageDispatcher.addListener(this, 803);
        messageDispatcher.addListener(this, 322);
        tileDesignationDictionary.init();
    }

    public GameInteractionStateContainer getState() {
        return this.interactionStateContainer;
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case 200: {
                MouseChangeMessage mouseChangeMessage = (MouseChangeMessage)msg.extraInfo;
                if (mouseChangeMessage.getButtonType().equals((Object)MouseChangeMessage.MouseButtonType.PRIMARY_BUTTON)) {
                    this.interactionStateContainer.setStartPoint(mouseChangeMessage.getWorldPosition());
                    this.interactionStateContainer.setCurrentPoint(mouseChangeMessage.getWorldPosition());
                    if (this.interactionStateContainer.getInteractionMode().isDraggable) {
                        this.interactionStateContainer.setDragging(true);
                    }
                }
                return true;
            }
            case 201: {
                MouseChangeMessage mouseChangeMessage = (MouseChangeMessage)msg.extraInfo;
                if (mouseChangeMessage.getButtonType().equals((Object)MouseChangeMessage.MouseButtonType.PRIMARY_BUTTON)) {
                    this.primaryButtonClicked(mouseChangeMessage);
                } else if (mouseChangeMessage.getButtonType().equals((Object)MouseChangeMessage.MouseButtonType.CANCEL_BUTTON)) {
                    this.cancelButtonClicked();
                } else {
                    this.messageDispatcher.dispatchMessage(-7, new DebugMessage(mouseChangeMessage.getWorldPosition()));
                }
                return true;
            }
            case 202: {
                MouseChangeMessage mouseChangeMessage = (MouseChangeMessage)msg.extraInfo;
                if (this.interactionStateContainer.isDragging()) {
                    this.interactionStateContainer.setCurrentPoint(mouseChangeMessage.getWorldPosition());
                }
                return true;
            }
            case 203: {
                if (this.interactionStateContainer.isDragging()) {
                    MouseChangeMessage mouseChangeMessage = (MouseChangeMessage)msg.extraInfo;
                    this.interactionStateContainer.setCurrentPoint(mouseChangeMessage.getWorldPosition());
                }
                return true;
            }
            case 802: {
                GameMaterial selectedMaterial = (GameMaterial)msg.extraInfo;
                this.interactionStateContainer.setSelectedMaterialForFurniture(selectedMaterial);
                this.rebuildFurnitureEntity();
                return true;
            }
            case 257: {
                FurnitureType selectedType = (FurnitureType)msg.extraInfo;
                this.interactionStateContainer.setSelectedFurnitureType(selectedType);
                this.rebuildFurnitureEntity();
                return true;
            }
            case 803: {
                FurnitureEntityAttributes attributes;
                Entity furnitureEntity;
                if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.PLACE_FURNITURE) && (furnitureEntity = this.interactionStateContainer.getFurnitureEntityToPlace()) != null && (attributes = (FurnitureEntityAttributes)furnitureEntity.getPhysicalEntityComponent().getAttributes()).getCurrentLayout().getRotatesTo() != null) {
                    attributes.setCurrentLayout(attributes.getCurrentLayout().getRotatesTo());
                    this.messageDispatcher.dispatchMessage(324, furnitureEntity);
                }
                return true;
            }
            case 322: {
                EntityMessage message;
                if (this.interactionStateContainer.getSelectedEntity() != null && (message = (EntityMessage)msg.extraInfo).getEntityId() == this.interactionStateContainer.getSelectedEntity().getId()) {
                    this.interactionStateContainer.setSelectedEntity(null);
                    this.messageDispatcher.dispatchMessage(251, (Object)GuiViewName.DEFAULT_MENU);
                    this.messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.DEFAULT);
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private void rebuildFurnitureEntity() {
        FurnitureType selectedFurnitureType = this.interactionStateContainer.getSelectedFurnitureType();
        GameMaterial materialForFurniture = this.interactionStateContainer.getSelectedMaterialForFurniture();
        if (selectedFurnitureType == null || materialForFurniture == null) {
            return;
        }
        if (selectedFurnitureType.getName().equals("BASIC_LANTERN") && !materialForFurniture.getMaterialType().equals((Object)GameMaterialType.METAL)) {
            return;
        }
        FurnitureEntityAttributes attributes = this.furnitureEntityAttributesFactory.byType(selectedFurnitureType, materialForFurniture);
        Entity furnitureEntity = this.furnitureEntityFactory.create(attributes, new GridPoint2(), null, null);
        this.interactionStateContainer.setFurnitureEntityToPlace(furnitureEntity);
    }

    private void primaryButtonClicked(MouseChangeMessage mouseChangeMessage) {
        if (this.interactionStateContainer.isDragging()) {
            this.interactionStateContainer.setDragging(false);
            if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.PLACE_ROOM)) {
                RoomPlacementMessage roomPlacementMessage = new RoomPlacementMessage(this.interactionStateContainer.virtualRoom.getRoomTiles(), this.interactionStateContainer.getInteractionMode().getRoomType());
                this.messageDispatcher.dispatchMessage(249, roomPlacementMessage);
            } else {
                AreaSelectionMessage areaSelectionMessage = new AreaSelectionMessage(this.interactionStateContainer.getMinPoint(), this.interactionStateContainer.getMaxPoint());
                this.messageDispatcher.dispatchMessage(250, areaSelectionMessage);
            }
        } else if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.DEFAULT) && this.gameContext != null) {
            final Vector2 worldClickPosition = mouseChangeMessage.getWorldPosition();
            ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
            for (MapTile nearbyTile : this.gameContext.getAreaMap().getNearestTiles(worldClickPosition)) {
                nearbyEntities.addAll(nearbyTile.getEntities());
            }
            Optional<Entity> nearestEntity = nearbyEntities.stream().filter(e -> e.getLocationComponent().getWorldPosition().dst2(worldClickPosition) < 0.25f).sorted(new Comparator<Entity>(){

                @Override
                public int compare(Entity o1, Entity o2) {
                    float o1Distance = Math.abs(o1.getLocationComponent().getWorldPosition().dst2(worldClickPosition) - o1.getLocationComponent().getRadius() * o1.getLocationComponent().getRadius());
                    float o2Distance = Math.abs(o2.getLocationComponent().getWorldPosition().dst2(worldClickPosition) - o2.getLocationComponent().getRadius() * o2.getLocationComponent().getRadius());
                    return (int)((o1Distance - o2Distance) * 1000.0f);
                }
            }).findFirst();
            if (nearestEntity.isPresent()) {
                nearestEntity.get();
                this.interactionStateContainer.setSelectedEntity(nearestEntity.get());
                this.messageDispatcher.dispatchMessage(251, (Object)GuiViewName.ENTITY_SELECTED);
            }
        } else if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.PLACE_FURNITURE)) {
            if (this.interactionStateContainer.isValidFurniturePlacement()) {
                this.messageDispatcher.dispatchMessage(805, new FurniturePlacementMessage(this.interactionStateContainer.getFurnitureEntityToPlace()));
            }
        } else if (this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.PLACE_DOOR) && this.interactionStateContainer.isValidDoorPlacement()) {
            this.messageDispatcher.dispatchMessage(806, this.interactionStateContainer.getVirtualDoorPlacement());
        }
    }

    private void cancelButtonClicked() {
        this.interactionStateContainer.setSelectedEntity(null);
        if (this.interactionStateContainer.isDragging()) {
            this.interactionStateContainer.setDragging(false);
        } else if (!this.interactionStateContainer.getInteractionMode().equals((Object)GameInteractionMode.DEFAULT)) {
            this.messageDispatcher.dispatchMessage(252, (Object)GameInteractionMode.DEFAULT);
        } else {
            this.messageDispatcher.dispatchMessage(253);
        }
    }

    @Override
    public void dispose() {
        this.messageDispatcher.removeListener((Telegraph)this, 200);
        this.messageDispatcher.removeListener((Telegraph)this, 201);
        this.messageDispatcher.removeListener((Telegraph)this, 202);
        this.messageDispatcher.removeListener((Telegraph)this, 203);
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

